
%%%%%% SSPE -- MAIN CODE %%%%

% CODE IMPLEMENTED TO SOLVE THE PARABOLIC EQUATION METHOD 
% SPLIT-STEP PARABOLIC EQUATION (SSPE) NUMERICAL SOLUTION
% NAPE AND WAPE ALGORITHMS
% AUTHOR: DIEGO ANDRS PARADA ROZO, YEAR: 2017
% GAPTEM - UFMG

% APPLICATION ON PROBLEMS INVOLVING PERFECTLY ELECTRICAL 
% CONDUCTING SURFACES (PEC)
%tic
%LOADING INPUT PARAMETERS
Input_Parameters;

%LOADING SOURCES -- INITIAL VERTICAL FIELD PROFILE
%u1=zeros(Nzz1,1) ;
%u1(cell_ht) = 1 ;
%u1=ones(Nzz1,1);
%Dipolo_Infinitesimal ;
Initial_Field_code ; 
%Images_PEC ;
%Hphi ;
%AntennaPattern;
%Half_Wavelength_Dipole ;

%LOADING TERRAIN FACTORS
Terrain;
%TERRAIN APPROXIMATION
Staircase;

%LOADING ATMOSPHERIC CONDITIONS
Atmospheric_Conditions;
%Matrix_Refractivity ;
%atmosphere2 ;

%ATTENUATION LAYER
Filter_Hanning;

%DEFINING US TO BEGIN SSPE ALGORITHM
u1i = u1 ; %%% INITIAL FIELD FROM SOURCE
u1N = u1 ; %%%  INITIAL FIELD -- NAPE 
u1W = u1 ; %%%  INITIAL FIELD -- WAPE

%DEFINING 'MATRIX-SOLUTION' SSPE% 
%SPACE DOMAIN MESH
%uN = zeros(Nz+1,Nx); % MATRIX-- NAPE SOLUTION (INITIALIZING)
%uW = zeros(Nz+1,Nx); % MATRIX-- WAPE SOLUTION (INITIALIZING)

uN = zeros(Nz,Nx); % MATRIX-- NAPE SOLUTION (INITIALIZING)
uW = zeros(Nz,Nx); % MATRIX-- WAPE SOLUTION (INITIALIZING)

%%%%%% SSPE ALGORITHM %%%%%%%%
mx=1 ;
tic
for w= 2:Nx+1
    
    delz = tz(w) - tz(w-1) ;
    Nzx = round(delz/dz) ;
    
    if w == 2
       Nzz1 = Nzz1 - Nzx ;
    else
       Nzz1 = Nzp - Nzx ;   
    end
    
%     if Nzz1 > Nz
%         Nzz1 = Nz ;
%     end
    
   Nzz(mx) = Nzz1 ;
   mx = mx + 1 ;
    
   Nzp = Nzz1  ;
   
   %P-EXPONENTIAL
   p=(pmax/(Nzp):(pmax/(Nzp)):pmax);
   pexN = exp( (-1i*(p.^2)*dx) / (2*k0) )'; %P-EXPONENTIAL--NAPE
   pexW = exp( (-1i.*(p.^2).*dx/k0).*( sqrt(1-((p.^2)/(k0^2))) + 1).^(-1) )' ; %P-EXPONENTIAL--WAPE
   
   %n-EXPONENTIAL 
  % n= n1(Nzi-Nzp: end) ; n=n';
  %n=REFR(Nzi-Nzp+1 : end, w-1) ; n=n'; % under Horizontally Variable Refractive conditions
   nexN = exp(1i*k0*(n.^2-1).*0.5*dx); %n-EXPONENTIAL--NAPE
   %nexN = exp(1i*k0*(n).*0.5*dx); %n-EXPONENTIAL--NAPE
   nexW = exp(1i*k0*(n-1).*dx); %n-EXPONENTIAL--WAPE
   
   %ADJUSTING THE SIZE OF THE VERTICAL VECTOR
   %BASED ON THE PREVIOUS STEP
   
   if delz >= 0 
       u1N = u1N(Nzx + 1 : end );
       u1W = u1W(Nzx + 1 : end );
   else 
       u1N =[ zeros(-Nzx,1);u1N];
       u1W =[ zeros(-Nzx,1);u1W]; 
   end 
   
   % CALCULATING SSPE AT ACTUAL POSITION - FILLING THE 'SOLUTION MATRIX'
   
   if Polarization ==1
   % NAPE APPROACH
   u1N = idct(dct(u1N).*pexN).*nexN'.*af((Nzi-(length(u1W)))+1: end );   % VERTICAL POLARIZATION
   uN(( Nzi-(length(u1N)))+1: end , w-1 )=u1N;
   % WAPE APPROACH
   u1W = idct(dct(u1W).*pexW).*nexW'.*af((Nzi-(length(u1W)))+1: end );   % VERTICAL POLARIZATION
   uW( (Nzi-(length(u1W)))+1: end , w-1 )= u1W;
    
   else
       
   % NAPE APPROACH
   u1N = idst(dst(u1N).*pexN).*nexN'.*af((Nzi-(length(u1W))) + 1 : end );   % HORIZONTAL POLARIZATION
   uN(( Nzi-(length(u1N)))+ 1 : end , w-1 )=u1N;
   % WAPE APPROACH
   u1W = idst(dst(u1W).*pexW).*nexW'.*af((Nzi-(length(u1W))) + 1 : end );   % HORIZONTAL POLARIZATION
   uW( (Nzi-(length(u1W)))+ 1 : end , w-1 )= u1W;
   
   end
   
end
toc
HyN = exp(1i*k0.*X).*uN ; EzN = (abs(HyN).*etha); %./sqrt(X) ;
HyW = exp(1i*k0.*X).*uW ; EzW = (abs(HyW).*etha); %./sqrt(X) ;

% HyN = 1.*uN ; EzN = HyN.*etha ;
% HyW = 1.*uW ; EzW = HyW.*etha ;
%%%%%%% CALCULATION R -- DISTANCE %%%

% R = zeros(Nz,Nx) ;
% for rx=1:length(Range)
%     
%     for rz = 1:length(z)
%         
%         R(rz,rx) = ( (Range(rx))^2 + ( z(rz)-ht )^2 )^(0.5) ; 
%         
%     end
% end

%%%%% Ez -- Cylindrical Factor %%%%% 

%Factor = (exp(-1i*k0.*X)./(sqrt(X))) ;
% Factor = 1./ (sqrt(X)) ;
% EzzN = EzN.*Factor ;  EzzW = EzW.*Factor ;

% Relation_Field_N = zeros(Nz,Nx);
% Relation_Field_W = zeros(Nz,Nx);
% 
% for cc = 1:Nx
%     
%     Relation_Field_N(:,cc) =  -20.*log10( abs(EzN(:,cc)))  ;
%     Relation_Field_W(:,cc) =  -20.*log10( abs(EzW(:,cc)))  ;
%     
% end

%Attenuation_N = -20.*log10( ( abs(EzN)./sqrt(X) )./ abs(max(e))) ;
%Attenuation_W = -20.*log10(abs(EzW)) ;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%% CALCULATION OF RESULTS %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%% Propagation Factor (PF) %%%%
%PF_N = 20.*log10(abs(uN)) + 10.*log10(X) + 10.*log10(lambda) ; % PF NAPE APPROACH
%PF_W = 20.*log10(abs(uW)) + 10.*log10(X) + 10.*log10(lambda) ; % PF WAPE APPROACH
% 
% %%%% Path Loss (PL) %%%%
%PL_N= -20*log10(abs(uN)) + 20*log10(4*pi) + 10*log10(X) - 30*log10(lambda) ; % PL NAPE APPROACH
%PL_W= -20*log10(abs(uW)) + 20*log10(4*pi) + 10*log10(X) - 30*log10(lambda) ; % PL WAPE APPROACH
% 
% %%%% Path Loss (PL) %%%%
 Pr_N= 20.*log10( abs( (lambda/(4*pi))*(1./sqrt(X)).*uN ) );
% Pr_W= 20.*log10( abs( (lambda/(4*pi))*(1./sqrt(X)).*uW ) );% PL NAPE APPROACH
% Pr_N1= 20.*log10( abs( (lambda/(4*pi))*( ones(Nz,1)*(1./sqrt(dx*([3:Nx+2]))) ).*uN.*etha.*sqrt(60) ) ); % PL NAPE APPROACH
% Pr_W= 20.*log10( abs( (lambda/(4*pi))*(1./sqrt(X)).*uW ) ) ; % PL WAPE APPROACH
% 
%figure(); plot(Range, PL_N(round(ht/dz),:),'r',Range,PL_W(round(ht/dz),:),'k')
%figure(); plot(Range, PF_N(round(ht/dz),:),'r',Range,PF_W(round(ht/dz),:),'k')
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% %%%%%% RESULTS DISPLAY %%%%%%%%%%%%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
 uN(uN==0)=nan; uW(uW==0)=nan; EzN(EzN==0)=nan; EzW(EzW==0)=nan; EzzN(EzN==0)=nan; EzzW(EzW==0)=nan; 
% % % 
% % % figure(1)  %% TERRAIN PROFILE %%
% % % plot(tx,tz); ylim([0 zmax]); xlim([d0+dx xmax]);
% % % title('Terrain Profile')
% % % xlabel('Distance (m)')
% % % ylabel('Height (m)')
% % % 
% % % figure(2)
% % % mesh(MM);az=0;el=90;view(az,el);colorbar; 
% % % title('Staircase-Terrain')
% % % xlabel('Nx')
% % % ylabel('Nz')
% % % 
% % % figure(3)
% % % plot(Range,Nzz); grid; xlim([d0+dx xmax]);
% % % 
% % % figure(4)
% % % mesh(X,Z,abs(PF_N)); view(2); xlim([d0+dx xmax]);
% % % %mesh(X(2:end,1:end),Z,abs(PF_N)); view(2); xlim([d0+dx xmax]);
% % % title('Propagation Factor - NAPE Results')
% % % xlabel('Distance (m)')
% % % ylabel('Height (m)')
% % % 
% % % figure(5)
% % % mesh(X,Z,abs(PF_W)); view(2); xlim([d0+dx xmax]);
% % % title('Propagation Factor - WAPE Results')
% % % xlabel('Distance (m)')
% % % ylabel('Height (m)')
% % % 
% % % figure(6)
% % % mesh(X,Z,abs(PL_N)); view(2); xlim([d0+dx xmax]);
% % % mesh(X,Z,abs(PL_N)); view(2); xlim([d0+dx xmax]);
% % % title('Path Loss - NAPE Results')
% % % xlabel('Distance (m)')
% % % ylabel('Height (m)')
% % % 
 %figure(7)
 %mesh(X,Z,abs(uN)); view(2); xlim([d0+dx xmax]);
% %mesh(X,Z,abs(PL_W)); view(2); xlim([d0+dx xmax]);
% title('Path Loss - NAPE Results')
% xlabel('Distance (m)')
% ylabel('Height (m)')
% 
 figure(8)
mesh(X,Z,Pr_N); view(2); xlim([d0+dx xmax]); ylim([0 za]); 
% %mesh(X,Z,abs(PL_W)); view(2); xlim([d0+dx xmax]);
% title('Path Loss - NAPE Results')
xlabel('Distance (km)')
ylabel('Height (m)')
% % % 
%figure()
%mesh(X,Z,abs(uN)); view(2); xlim([d0+dx xmax]);
%title('Ez - NAPE Results')
%xlabel('Distance (m)')
%ylabel('Height (m)')
% % % 
%figure()
%mesh(X,Z,abs(uW)); view(2); xlim([d0+dx xmax]);
%title('Ez - WAPE Results')
%xlabel('Distance (m)')
%ylabel('Height (m)')
% 
% 
Results ;

%%%%%%%%%

%   HR = 50 ; H_cells = round(HR/dz) ; PL_H = Pr_N(H_cells, :);
%   Rangex = d0+dx:dx:xmax ; 
%    plot(Rangex,PL_H,'r') ; xlim([500 xmax]) ; 
% % % 
%   XR = 5000 ; X_cells = round(XR/dx) ; PL_V = Pr_N(:,X_cells) ;
%   zz = dz:dz:zmax ;
%    plot(PL_V,zz,'r') ;  ylim([dz za]) ;