
%%%% DEFINING INPUT PARAMETERS %%%

c= 3e8; % LIGHT VELOCITY
f= 10e9; % FREQUENCY
lambda=c/f; % WAVELENGTH
k0=(2*pi)/lambda; % FREE-SPACE WAVENUMBER
etha=120*pi; % INTRINSIC IMPEDANCE

dx= 10; %  SIZE OF THE STEP IN X--AXIS
d0= 50; % INITIAL POSITION IN X--AXIS

xmax = 20000 + d0; % MAXIMUM RANGE
Terrain ;    % LOADING COORDINATES (Tx,Tz)

Nx= round((xmax-d0)/dx); %NUMBER OF CELLS IN X-AXIS

alfamax= 8;  % MAXIMUM PROPAGATION ANGLE
pmax=k0*sind(alfamax);
dz = pi/pmax; %  SIZE OF THE STEP AT Z--AXIS

zmax= 500; %MAXIMUM HEIGHT
za = 0.5*zmax ;
Nz= round((zmax-min(tz))/dz); %NUMBER OF CELLS IN Z-AXIS WITH RESPECT TO THE MINIMUM HEIGHT
%Nzz1 = round((zmax-tz(1))/dz)+1; %NUMBER OF CELLS IN Z-AXIS WITH RESPECT TO HEIGHT AT d0.
%Nz= round((zmax-min(tz))/dz) + 1;
Nzz1 = round((zmax-tz(1))/dz); %NUMBER OF CELLS IN Z-AXIS WITH RESPECT TO HEIGHT AT d0.

%Nzi=Nz+1; 
Nzi=Nz;
criteria_dz= lambda/(2*sind(alfamax));
z= min(tz)+dz:dz:Nz*dz; % DISCRETIZED Z--AXIS
%z= min(tz):dz:Nz*dz;
%z=0:dz:Nz*dz; % DISCRETIZED Z--AXIS

% FOR VERTICAL POLARIZATION CASE, Polarization=1
% FOR HORIZONTAL POLARIZATION CASE, Polarization=0
Polarization = 0 ;

Range = d0+dx:dx:xmax; % DISCRETIZED X--AXIS

ht=30; %cell_ht= round(ht/dz); %ANTENNA HEIGHT 
%l= lambda/2; % ANTENNA LENGTH
%u1=zeros(Nzz1,1) ;
%u1(cell_ht) = 1 ;