 
%%%% IMAGE THEORY %%%%
%%%% VERTICAL ELECTRIC DIPOLE %%%%%

Input_Parameters ; 
 
hr = dz:dz:Nzz1*dz ; % RECEIVER POINTS 
x = d0 ; % REFERENCE DISTANCE

R = zeros(length(hr),length(x));
tetha = zeros(length(hr),length(x));
Ez0 = zeros(length(hr),length(x));

Pr = 1;
Rpc =  (2*pi*etha)*((l/lambda)^2)*( (1/3) - (cos(2*k0*ht)/((2*k0*ht)^2)) + (sin(2*k0*ht)/ ((2*k0*ht)^3)) ) ;  
Rfs = 80*(pi^2)*(l/lambda)^2 ; 
IL = (1/k0)*sqrt((Pr*Rfs)/(10*Rpc)) ;

    
for nn = 1:length(hr)
        
        R(nn) = ( x^2 + hr(nn)^2 )^(0.5);
        
        tetha(nn) = atan( x / hr(nn));
        
        Ez0(nn) = (-(1i*etha*k0*IL)/(4*pi*R(nn)))* exp(-1i*k0*R(nn)) * (sin(tetha(nn)))^2 * (2*cos(k0*ht*cos(tetha(nn)))) ; 
        
end
    

Initial_Field = abs(Ez0)./etha ; Hy0 = Initial_Field ;
u1 = Hy0.*exp(-1i*k0*x); %u1=ui' ;
