%%% Antenna/Source Injection %%%
%
%Created: 16/04/2019
%Modified: 29/04/2019
%Juliana M. Mendes
%
%In most of the 2D propagation models, the source is modeled in a
%transmitting antenna's pattern that is located vertically at the initial
%range. This can be achieved by using a vertical Gaussian Field profile. -
%Page 47(Gokhan, Sevgi)

clear all
clc

%Frequence[MHz]
f=300;
%Speed of light
c=3e8;
%Wave length
lambda=c/f;
%Wave number
k0=(2*pi)/lambda;

%Thetha [Degree]
ThethaDegree=-90:0.1:90;
%Thetha Radian
Thetha=ThethaDegree*pi/180;
%Wavenumber for free space
kx=k0*sin(Thetha);

%Thetha BW [Degree]
ThethaBWDegree=10;
%Thetha BW Radian
ThethaBW=ThethaBWDegree*pi/180;

%Tilt Angle: The tilt angle (thethaElv) is introduced by replacing f(kx)with
%f(kx-k0sinThethaElv),[Degree]
ThethaElvDegree=0;
%Tilt Angle Radian
ThethaElv=ThethaElvDegree*pi/180;

%Antenna pattern: Gaussian 
f=exp(-(kx.^2*log(2))/(2*k0^2*sin(ThethaBW/2)^2));

%Plot Over [-1 1] as shown in page 44
plot(f,ThethaDegree)
axis([0 1.2 -90 90])
title('Antenna Pattern')
xlabel('W(\theta)')
ylabel('\theta [Degree]')


