% update incident fields for the current time step
if incident_plane_wave.enable == false
    return;
end

tm = current_time + dt/2;
te = current_time + dt;

wt_str = incident_plane_wave.waveform_type;    
wi = incident_plane_wave.waveform_index; 

% if waveform is Gaussian waveforms
% tau = incident_plane_wave.tau;
% t_0 = incident_plane_wave.t_0;
% 
% Exi_yn = Exi0 * exp(-((tm - t_0 - k_dot_r_ex_yn )/tau).^2);
% Exi_yp = Exi0 * exp(-((tm - t_0 - k_dot_r_ex_yp )/tau).^2);
% Exi_zn = Exi0 * exp(-((tm - t_0 - k_dot_r_ex_zn )/tau).^2);
% Exi_zp = Exi0 * exp(-((tm - t_0 - k_dot_r_ex_zp )/tau).^2);
% 
% Eyi_zn = Eyi0 * exp(-((tm - t_0 - k_dot_r_ey_zn )/tau).^2);
% Eyi_zp = Eyi0 * exp(-((tm - t_0 - k_dot_r_ey_zp )/tau).^2);
% Eyi_xn = Eyi0 * exp(-((tm - t_0 - k_dot_r_ey_xn )/tau).^2);
% Eyi_xp = Eyi0 * exp(-((tm - t_0 - k_dot_r_ey_xp )/tau).^2);
% 
% Ezi_xn = Ezi0 * exp(-((tm - t_0 - k_dot_r_ez_xn )/tau).^2);
% Ezi_xp = Ezi0 * exp(-((tm - t_0 - k_dot_r_ez_xp )/tau).^2);
% Ezi_yn = Ezi0 * exp(-((tm - t_0 - k_dot_r_ez_yn )/tau).^2);
% Ezi_yp = Ezi0 * exp(-((tm - t_0 - k_dot_r_ez_yp )/tau).^2);
% 
% Hxi_yn = Hxi0 * exp(-((te - t_0 - k_dot_r_hx_yn )/tau).^2);
% Hxi_yp = Hxi0 * exp(-((te - t_0 - k_dot_r_hx_yp )/tau).^2);
% Hxi_zn = Hxi0 * exp(-((te - t_0 - k_dot_r_hx_zn )/tau).^2);
% Hxi_zp = Hxi0 * exp(-((te - t_0 - k_dot_r_hx_zp )/tau).^2);
% 
% Hyi_zn = Hyi0 * exp(-((te - t_0 - k_dot_r_hy_zn )/tau).^2);
% Hyi_zp = Hyi0 * exp(-((te - t_0 - k_dot_r_hy_zp )/tau).^2);
% Hyi_xn = Hyi0 * exp(-((te - t_0 - k_dot_r_hy_xn )/tau).^2);
% Hyi_xp = Hyi0 * exp(-((te - t_0 - k_dot_r_hy_xp )/tau).^2);
% 
% Hzi_xn = Hzi0 * exp(-((te - t_0 - k_dot_r_hz_xn )/tau).^2);
% Hzi_xp = Hzi0 * exp(-((te - t_0 - k_dot_r_hz_xp )/tau).^2);
% Hzi_yn = Hzi0 * exp(-((te - t_0 - k_dot_r_hz_yn )/tau).^2); 
% Hzi_yp = Hzi0 * exp(-((te - t_0 - k_dot_r_hz_yp )/tau).^2);

% if waveform is Gaussian waveforms
if strcmp(incident_plane_wave.waveform_type,'gaussian')
%     tau = waveforms.gaussian(wi).tau;
%     t_0 = waveforms.gaussian(wi).t_0;
    tau = incident_plane_wave.tau;
    t_0 = incident_plane_wave.t_0;

    Exi_yn = Exi0 * exp(-((tm - t_0 - k_dot_r_ex_yn )/tau).^2);
    Exi_yp = Exi0 * exp(-((tm - t_0 - k_dot_r_ex_yp )/tau).^2);
    Exi_zn = Exi0 * exp(-((tm - t_0 - k_dot_r_ex_zn )/tau).^2);
    Exi_zp = Exi0 * exp(-((tm - t_0 - k_dot_r_ex_zp )/tau).^2);

    Eyi_zn = Eyi0 * exp(-((tm - t_0 - k_dot_r_ey_zn )/tau).^2);
    Eyi_zp = Eyi0 * exp(-((tm - t_0 - k_dot_r_ey_zp )/tau).^2);
    Eyi_xn = Eyi0 * exp(-((tm - t_0 - k_dot_r_ey_xn )/tau).^2);
    Eyi_xp = Eyi0 * exp(-((tm - t_0 - k_dot_r_ey_xp )/tau).^2);

    Ezi_xn = Ezi0 * exp(-((tm - t_0 - k_dot_r_ez_xn )/tau).^2);
    Ezi_xp = Ezi0 * exp(-((tm - t_0 - k_dot_r_ez_xp )/tau).^2);
    Ezi_yn = Ezi0 * exp(-((tm - t_0 - k_dot_r_ez_yn )/tau).^2);
    Ezi_yp = Ezi0 * exp(-((tm - t_0 - k_dot_r_ez_yp )/tau).^2);

    Hxi_yn = Hxi0 * exp(-((te - t_0 - k_dot_r_hx_yn )/tau).^2);
    Hxi_yp = Hxi0 * exp(-((te - t_0 - k_dot_r_hx_yp )/tau).^2);
    Hxi_zn = Hxi0 * exp(-((te - t_0 - k_dot_r_hx_zn )/tau).^2);
    Hxi_zp = Hxi0 * exp(-((te - t_0 - k_dot_r_hx_zp )/tau).^2);

    Hyi_zn = Hyi0 * exp(-((te - t_0 - k_dot_r_hy_zn )/tau).^2);
    Hyi_zp = Hyi0 * exp(-((te - t_0 - k_dot_r_hy_zp )/tau).^2);
    Hyi_xn = Hyi0 * exp(-((te - t_0 - k_dot_r_hy_xn )/tau).^2);
    Hyi_xp = Hyi0 * exp(-((te - t_0 - k_dot_r_hy_xp )/tau).^2);

    Hzi_xn = Hzi0 * exp(-((te - t_0 - k_dot_r_hz_xn )/tau).^2);
    Hzi_xp = Hzi0 * exp(-((te - t_0 - k_dot_r_hz_xp )/tau).^2);
    Hzi_yn = Hzi0 * exp(-((te - t_0 - k_dot_r_hz_yn )/tau).^2); 
    Hzi_yp = Hzi0 * exp(-((te - t_0 - k_dot_r_hz_yp )/tau).^2);
%     Exic = Exi0 * exp(-((te - t_0 - k_dot_r_ex )/tau).^2);
%     Eyic = Eyi0 * exp(-((te - t_0 - k_dot_r_ey )/tau).^2);
%     Ezic = Ezi0 * exp(-((te - t_0 - k_dot_r_ez )/tau).^2);
%     Hxic = Hxi0 * exp(-((tm - t_0 - k_dot_r_hx )/tau).^2);
%     Hyic = Hyi0 * exp(-((tm - t_0 - k_dot_r_hy )/tau).^2);
%     Hzic = Hzi0 * exp(-((tm - t_0 - k_dot_r_hz )/tau).^2);
end

% if waveform is cosine modulated Gaussian 
if strcmp(incident_plane_wave.waveform_type,'cosine_modulated_gaussian')
%     f = waveforms.cosine_modulated_gaussian(wi).modulation_frequency;
    f = 0.3e9;
%     tau = waveforms.cosine_modulated_gaussian(wi).tau;
%     t_0 = waveforms.cosine_modulated_gaussian(wi).t_0;
    tau = incident_plane_wave.tau;
    t_0 = incident_plane_wave.t_0;
%     Exic = Exi0 * cos(2*pi*f*(te - t_0 - k_dot_r_ex)).*exp(-((te - t_0 - k_dot_r_ex)/tau).^2);
%     Eyic = Eyi0 * cos(2*pi*f*(te - t_0 - k_dot_r_ey)).*exp(-((te - t_0 - k_dot_r_ey)/tau).^2);
%     Ezic = Ezi0 * cos(2*pi*f*(te - t_0 - k_dot_r_ez)).*exp(-((te - t_0 - k_dot_r_ez)/tau).^2);
%     Hxic = Hxi0 * cos(2*pi*f*(tm - t_0 - k_dot_r_hx)).*exp(-((tm - t_0 - k_dot_r_hx)/tau).^2);
%     Hyic = Hyi0 * cos(2*pi*f*(tm - t_0 - k_dot_r_hy)).*exp(-((tm - t_0 - k_dot_r_hy)/tau).^2);
%     Hzic = Hyi0 * cos(2*pi*f*(tm - t_0 - k_dot_r_hz)).*exp(-((tm - t_0 - k_dot_r_hz)/tau).^2);
    
    Exi_yn = Exi0 * cos(2*pi*f*(tm - t_0 - k_dot_r_ex_yn)).*exp(-((tm - t_0 - k_dot_r_ex_yn )/tau).^2);
    Exi_yp = Exi0 * cos(2*pi*f*(tm - t_0 - k_dot_r_ex_yp)).*exp(-((tm - t_0 - k_dot_r_ex_yp )/tau).^2);
    Exi_zn = Exi0 * cos(2*pi*f*(tm - t_0 - k_dot_r_ex_zn)).*exp(-((tm - t_0 - k_dot_r_ex_zn )/tau).^2);
    Exi_zp = Exi0 * cos(2*pi*f*(tm - t_0 - k_dot_r_ex_zp)).*exp(-((tm - t_0 - k_dot_r_ex_zp )/tau).^2);

    Eyi_zn = Eyi0 * cos(2*pi*f*(tm - t_0 - k_dot_r_ey_zn)).*exp(-((tm - t_0 - k_dot_r_ey_zn )/tau).^2);
    Eyi_zp = Eyi0 * cos(2*pi*f*(tm - t_0 - k_dot_r_ey_zp)).*exp(-((tm - t_0 - k_dot_r_ey_zp )/tau).^2);
    Eyi_xn = Eyi0 * cos(2*pi*f*(tm - t_0 - k_dot_r_ey_xn)).*exp(-((tm - t_0 - k_dot_r_ey_xn )/tau).^2);
    Eyi_xp = Eyi0 * cos(2*pi*f*(tm - t_0 - k_dot_r_ey_xp)).*exp(-((tm - t_0 - k_dot_r_ey_xp )/tau).^2);

    Ezi_xn = Ezi0 * cos(2*pi*f*(tm - t_0 - k_dot_r_ez_xn)).*exp(-((tm - t_0 - k_dot_r_ez_xn )/tau).^2);
    Ezi_xp = Ezi0 * cos(2*pi*f*(tm - t_0 - k_dot_r_ez_xp)).*exp(-((tm - t_0 - k_dot_r_ez_xp )/tau).^2);
    Ezi_yn = Ezi0 * cos(2*pi*f*(tm - t_0 - k_dot_r_ez_yn)).*exp(-((tm - t_0 - k_dot_r_ez_yn )/tau).^2);
    Ezi_yp = Ezi0 * cos(2*pi*f*(tm - t_0 - k_dot_r_ez_yp)).*exp(-((tm - t_0 - k_dot_r_ez_yp )/tau).^2);

    Hxi_yn = Hxi0 * cos(2*pi*f*(te - t_0 - k_dot_r_hx_yn)).*exp(-((te - t_0 - k_dot_r_hx_yn )/tau).^2);
    Hxi_yp = Hxi0 * cos(2*pi*f*(te - t_0 - k_dot_r_hx_yp)).*exp(-((te - t_0 - k_dot_r_hx_yp )/tau).^2);
    Hxi_zn = Hxi0 * cos(2*pi*f*(te - t_0 - k_dot_r_hx_zn)).*exp(-((te - t_0 - k_dot_r_hx_zn )/tau).^2);
    Hxi_zp = Hxi0 * cos(2*pi*f*(te - t_0 - k_dot_r_hx_zp)).*exp(-((te - t_0 - k_dot_r_hx_zp )/tau).^2);

    Hyi_zn = Hyi0 * cos(2*pi*f*(te - t_0 - k_dot_r_hy_zn)).*exp(-((te - t_0 - k_dot_r_hy_zn )/tau).^2);
    Hyi_zp = Hyi0 * cos(2*pi*f*(te - t_0 - k_dot_r_hy_zp)).*exp(-((te - t_0 - k_dot_r_hy_zp )/tau).^2);
    Hyi_xn = Hyi0 * cos(2*pi*f*(te - t_0 - k_dot_r_hy_xn)).*exp(-((te - t_0 - k_dot_r_hy_xn )/tau).^2);
    Hyi_xp = Hyi0 * cos(2*pi*f*(te - t_0 - k_dot_r_hy_xp)).*exp(-((te - t_0 - k_dot_r_hy_xp )/tau).^2);

    Hzi_xn = Hzi0 * cos(2*pi*f*(te - t_0 - k_dot_r_hz_xn)).*exp(-((te - t_0 - k_dot_r_hz_xn )/tau).^2);
    Hzi_xp = Hzi0 * cos(2*pi*f*(te - t_0 - k_dot_r_hz_xp)).*exp(-((te - t_0 - k_dot_r_hz_xp )/tau).^2);
    Hzi_yn = Hzi0 * cos(2*pi*f*(te - t_0 - k_dot_r_hz_yn)).*exp(-((te - t_0 - k_dot_r_hz_yn )/tau).^2); 
    Hzi_yp = Hzi0 * cos(2*pi*f*(te - t_0 - k_dot_r_hz_yp)).*exp(-((te - t_0 - k_dot_r_hz_yp )/tau).^2);
end
