function varargout = source_waveforms(varargin)
% Graphical user interface for FDTD

mOutputArgs     = {};        % Variable for storing output when GUI returns
number_of_sources = varargin{1};
if nargin == 2
    selections = varargin{2};
    sz = size(selections, 2);
    if sz < number_of_sources
        for mi=sz+1: number_of_sources
            selections(mi) = 3;
        end
    end
    if sz > number_of_sources
        selections(number_of_sources+1:sz) = [];
    end
else
    selections = 3*ones(1, number_of_sources);
end

mbColor = [255 255 220]/255; % background color used in all windows
mFigureTag  = 'source_waveform_dlg';
mFigureName = 'Source waveforms';
mSelection  = 'Yes';
fpos        = [0 0 1 1];
        
hMainFigure    =   figure(...       % the main GUI figure
                        'tag','mFigureTag',...    
                        'menubar','none', ...
                        'Toolbar','none', ...
                        'HandleVisibility','callback', ...
                        'Name', mFigureName, ...
                        'NumberTitle','off', ...
                        'Color', mbColor, ...
                        'units','characters',... %'WindowStyle','modal',...
                        'KeyPressFcn',@close_CB,...
                        'resize','off','CloseRequestFcn',@close_CB);
                    
set(hMainFigure,'color','w');

str = strvcat('unit step', 'sinusoidal', 'gaussian', 'derivative of gaussian','cosine modulated gaussian'); 

for mi=1:number_of_sources
    ind = number_of_sources - mi + 1;
    pos = [11 3+(mi-1)*2 38 1];
    hObjectPopup(ind)  =   uicontrol(...    % list of object types 
                            'style', 'popup', ...
                            'Parent', hMainFigure, ...
                            'Units','characters',...
                            'HandleVisibility','callback', ...
                            'Position',pos,...
                            'String',str,...
                            'backgroundcolor','w', 'value', selections(ind));
    pos = [1 2.8+(mi-1)*2 10 1];
    hObjecttext    =   uicontrol(...    % list of object types 
                            'style', 'text', ...
                            'Parent', hMainFigure, ...
                            'Units','characters',...
                            'HandleVisibility','callback', ...
                            'horizontalalignment','left', ...
                            'Position',pos,...
                            'String',['source ' num2str(ind)],...
                            'backgroundcolor','w');
end

    pos = [24 0.8 10 1.4];
    hokbutton    =   uicontrol(...    % list of object types 
                            'style', 'pushbutton', ...
                            'Parent', hMainFigure, ...
                            'Units','characters',...
                            'HandleVisibility','callback', ...
                            'Position',pos,...
                            'String','ok',...
                            'keypressfcn',@okbuttonfcn,...
                            'callback',@okbuttonfcn);
    pos = [36 0.8 10 1.4];
    hcancelbutton    =   uicontrol(...    % list of object types 
                            'style', 'pushbutton', ...
                            'Parent', hMainFigure, ...
                            'Units','characters',...
                            'HandleVisibility','callback', ...
                            'Position',pos,...
                            'String','cancel',...
                            'Callback', @close_CB,'fontweight','bold');


pos = get(hMainFigure, 'position');
pos(3) = 50;
pos(4) = 3+(number_of_sources)*2;
set(hMainFigure, 'position', pos);

% define menus
%hFarfieldResults_MI = uimenu('Parent',hAnalysis_M,'Label','Farfield results','Callback',@hFarfieldResults_MI_CB);

% Define default output and return it if it is requested by users
 varargout{1} = 0;

 uiwait(hMainFigure);

%----------------------------------------------------------------------
function close_CB(src,evt)
    delete(gcf);
end
function okbuttonfcn(src,evt)
    for mi=1:number_of_sources
        selection(mi) = get(hObjectPopup(mi),'value');
    end
    varargout{1} = selection;
    delete(gcf);
end

end
