function [Ephi, Etheta] = mie_sphere_multi_diel_marlon_teste(freq, a0, a, epsr, phio, thetao, r)
% ***********************************************************************
% Scattered far-field of a dielectric sphere (Mie series solution)
% The incident electric field is polarized along the x-direction and
% propagates along the +z-direction, i.e., Einc_x = exp(-jkz)
%
% INPUT:
% freq  : frequency in MHz
% a     : radius of the cylinder (m)
% epsr  : dielectric constant of the dielectric
% phio  : Phi angle of observation point (radian)
% thetao: Theta angle of observation point (radian)
% r     : Radius of observation point (far-field distance) (m)
%
% OUTPUT:
% Ephi, Etheta: Phi and theta components of the scattered field
%

freq   = freq*1e6;    % Hz, frequency
c0     = 3*1e8;       % m/sec, velocity of light in free space
lambda = c0/freq;     % meter, wavelength
k      = 2*pi/lambda; % 1/meter, wavenumber
eps0 = (1e-9)/(36*pi);  % F/m, permittivity
mu0  = 4*pi*1e-7;       % H/m, permeability of free space

kd    = k*sqrt(epsr); % 1/meter, wavenumber inside the sphere
epsd  = eps0*epsr;
mur   = 1.0; 
mud   = mu0*mur;

ka = k*a(end);
kda = kd.*a;

n = 1:50; % terms in the summation


%% PEC sphere
dhankelka1 = (besselh(n-1/2,1,kd(1)*a0)-besselh(n+3/2,1,kd(1)*a0))/2;
hankelka1 = besselh(n+1/2,1,kd(1)*a0);
dshankelka1 = (pi/4)*((pi*kd(1)*a0/2)^(-1/2))*hankelka1 + sqrt(pi*kd(1)*a0/2)*dhankelka1;
shankelka1 = sqrt(pi*kd(1)*a0/2)*hankelka1;

dhankelka2 = (besselh(n-1/2,2,kd(1)*a0)-besselh(n+3/2,2,kd(1)*a0))/2;
hankelka2 = besselh(n+1/2,2,kd(1)*a0);
dshankelka2 = (pi/4)*((pi*kd(1)*a0/2)^(-1/2))*hankelka2 + sqrt(pi*kd(1)*a0/2)*dhankelka2;
shankelka2 = sqrt(pi*kd(1)*a0/2)*hankelka2;

dn_cn1 = -(dshankelka1./dshankelka2);
Dn_Cn1 = -(shankelka1./shankelka2);

%% RH and RE terms

for i = 1:length(a)
    
    dhankelkda1 = (besselh(n-1/2,1,kda(i))-besselh(n+3/2,1,kda(i)))/2;
    hankelkda1 = besselh(n+1/2,1,kda(i));
    dshankelkda1 = (pi/4)*((pi*kda(i)/2)^(-1/2))*hankelkda1 + sqrt(pi*kda(i)/2)*dhankelkda1;
    shankelkda1 = sqrt(pi*kda(i)/2)*hankelkda1;
    
    dhankelkda2 = (besselh(n-1/2,2,kda(i))-besselh(n+3/2,2,kda(i)))/2;
    hankelkda2 = besselh(n+1/2,2,kda(i));
    dshankelkda2 = (pi/4)*((pi*kda(i)/2)^(-1/2))*hankelkda2 + sqrt(pi*kda(i)/2)*dhankelkda2;
    shankelkda2 = sqrt(pi*kda(i)/2)*hankelkda2;
    
    if (i > 1)
        
        dhankelkda1_1 = (besselh(n-1/2,1,kd(i)*a(i-1))-besselh(n+3/2,1,kd(i)*a(i-1)))/2;
        hankelkda1_1 = besselh(n+1/2,1,kd(i)*a(i-1));
        dshankelkda1_1 = (pi/4)*((pi*kd(i)*a(i-1)/2)^(-1/2))*hankelkda1_1 + sqrt(pi*kd(i)*a(i-1)/2)*dhankelkda1_1;
        shankelkda1_1 = sqrt(pi*kd(i)*a(i-1)/2)*hankelkda1_1;

        dhankelkda2_1 = (besselh(n-1/2,2,kd(i)*a(i-1))-besselh(n+3/2,2,kd(i)*a(i-1)))/2;
        hankelkda2_1 = besselh(n+1/2,2,kd(i)*a(i-1));
        dshankelkda2_1 = (pi/4)*((pi*kd(i)*a(i-1)/2)^(-1/2))*hankelkda2_1 + sqrt(pi*kd(i)*a(i-1)/2)*dhankelkda2_1;
        shankelkda2_1 = sqrt(pi*kd(i)*a(i-1)/2)*hankelkda2_1;
        
        dn_cn1 = -(shankelkda1_1 - RH1.*dshankelkda1_1)./(shankelkda2_1 - RH1.*dshankelkda2_1);
        Dn_Cn1 = -(shankelkda1_1 - RE1.*dshankelkda1_1)./(shankelkda2_1 - RE1.*dshankelkda2_1);
        
    end
    
    if (i == length(a))
        RH1 = sqrt(epsd(i)/eps0).*((shankelkda1 + dn_cn1.*shankelkda2)./(dshankelkda1 + dn_cn1.*dshankelkda2));
        RE1 = sqrt(eps0/epsd(i)).*((shankelkda1 + Dn_Cn1.*shankelkda2)./(dshankelkda1 + Dn_Cn1.*dshankelkda2));
        break
    else     
        RH1 = sqrt(epsd(i)/epsd(i+1)).*((shankelkda1 + dn_cn1.*shankelkda2)./(dshankelkda1 + dn_cn1.*dshankelkda2));
        RE1 = sqrt(epsd(i+1)/epsd(i)).*((shankelkda1 + Dn_Cn1.*shankelkda2)./(dshankelkda1 + Dn_Cn1.*dshankelkda2));
    end
    
end

%% Outside dielectric

dbesselka = (besselj(n-1/2,ka)-besselj(n+3/2,ka))/2;
besselka = besselj(n+1/2,ka);
dsbesselka = (pi/4)*((pi*ka/2)^(-1/2))*besselka + sqrt(pi*ka/2)*dbesselka;
sbesselka = sqrt(pi*ka/2)*besselka;

dhankelka = (besselh(n-1/2,2,ka)-besselh(n+3/2,2,ka))/2;
hankelka = besselh(n+1/2,2,ka);
dshankelka = (pi/4)*((pi*ka/2)^(-1/2))*hankelka + sqrt(pi*ka/2)*dhankelka;
shankelka = sqrt(pi*ka/2)*hankelka;

an = 1j.^(-n).*(2*n+1)./(n.*(n+1));

bn = -an .* (sbesselka - RH1.*dsbesselka) ./ ...
          (shankelka - RH1.*dshankelka);

cn = -an .* (sbesselka - RE1.*dsbesselka) ./ ...
          (shankelka - RE1.*dshankelka);

%% derivative Legendre polynomial

legn1 = zeros(1,length(n));
legn2 = zeros(1,length(n));

for ii = 1:length(n)
    legn = legendre(ii,cos(thetao));
    legn1(ii) = legn(2);
    if length(legn)<3
       legn2(ii) = 0;
    else
       legn2(ii) = legn(3);
    end
end

dlegn1 = legn2+(cos(thetao)/sin(thetao))*legn1;

%% RHS of Scattered fields

Etheta = sum(1j.^n.*(bn.*dlegn1 + cn.*legn1/sin(thetao)));
Ephi = sum(1j.^n.*(bn.*legn1/sin(thetao) + cn.*dlegn1));

%% Scattered fields

Etheta = -Etheta*cos(phio)*1j*exp(-1j*k*r)/(k*r);
Ephi = Ephi*sin(phio)*1j*exp(-1j*k*r)/(k*r);
