disp('defining the problem space parameters');

% maximum number of time steps to run FDTD simulation
number_of_time_steps = 500; 
% number_of_time_steps = 500;  

% A factor that determines duration of a time step
% wrt CFL limit
courant_factor = 0.9;

% A factor determining the accuracy limit of FDTD results
number_of_cells_per_wavelength = 20; %20    

% Dimensions of a unit cell in x, y, and z directions (meters)
% dx = 7.5e-3;    
% dy = 7.5e-3;   
% dz = 7.5e-3;
ds = 40e-3;
dx = ds;    
dy = ds;   
dz = ds;

% ==<boundary conditions>========
% Here we define the boundary conditions parameters 
% 'pec' : perfect electric conductor
% 'cpml' : conlvolutional PML
% if cpml_number_of_cells is less than zero
% CPML extends inside of the domain rather than outwards

sized = 0.3; %0.4 m % Funciona 0.1 
sizepml = 0.4; % 0.5m % Funciona 0.2

domcells = sized/ds;
pmlcells = sizepml/ds;

boundary.type_xn = 'cpml';
boundary.air_buffer_number_of_cells_xn = domcells;
boundary.cpml_number_of_cells_xn = pmlcells;

boundary.type_xp = 'cpml';
boundary.air_buffer_number_of_cells_xp = domcells;
boundary.cpml_number_of_cells_xp = pmlcells;

boundary.type_yn = 'cpml';
boundary.air_buffer_number_of_cells_yn = domcells;
boundary.cpml_number_of_cells_yn = pmlcells;

boundary.type_yp = 'cpml';
boundary.air_buffer_number_of_cells_yp = domcells;
boundary.cpml_number_of_cells_yp = pmlcells;

boundary.type_zn = 'cpml';
boundary.air_buffer_number_of_cells_zn = domcells;
boundary.cpml_number_of_cells_zn = pmlcells;

boundary.type_zp = 'cpml';
boundary.air_buffer_number_of_cells_zp = domcells;
boundary.cpml_number_of_cells_zp = pmlcells;

boundary.cpml_order = 3; 
boundary.cpml_sigma_factor = 1.3;
boundary.cpml_kappa_max = 7;
boundary.cpml_alpha_min = 0;
boundary.cpml_alpha_max = 0.05;

% ===<material types>============
% Here we define and initialize the arrays of material types
% eps_r   : relative permittivity
% mu_r    : relative permeability
% sigma_e : electric conductivity
% sigma_m : magnetic conductivity

% air
material_types(1).eps_r   = 1;
material_types(1).mu_r    = 1;
material_types(1).sigma_e = 0;
material_types(1).sigma_m = 0; 
material_types(1).color   = [1 1 1];

% PEC : perfect electric conductor
material_types(2).eps_r   = 1;
material_types(2).mu_r    = 1;
material_types(2).sigma_e = 1e10;
material_types(2).sigma_m = 0; 
material_types(2).color   = [1 1 0];

% PMC : perfect magnetic conductor
material_types(3).eps_r   = 1;
material_types(3).mu_r    = 1;
material_types(3).sigma_e = 0;
material_types(3).sigma_m = 1e10;
material_types(3).color   = [0 1 0];

% substrate 
material_types(4).eps_r   = 4;
material_types(4).mu_r    = 1;
material_types(4).sigma_e = 0; 
material_types(4).sigma_m = 0; 
material_types(4).color   = [0 0 1];

% substrate 
material_types(5).eps_r   = 3;
material_types(5).mu_r    = 1;
material_types(5).sigma_e = 0; 
material_types(5).sigma_m = 0; 
material_types(5).color   = [1 0 1];

% substrate 
material_types(6).eps_r   = 2;
material_types(6).mu_r    = 1;
material_types(6).sigma_e = 0; 
material_types(6).sigma_m = 0; 
material_types(6).color   = [0 1 1];

% index of material types defining air, PEC, and PMC 
material_type_index_air = 1;
material_type_index_pec = 2;
material_type_index_pmc = 3;
material_type_index_diel1 = 4;
material_type_index_diel2 = 5;
material_type_index_diel3 = 6;
