% Capturing sampled currents

for ind=1:number_of_sampled_currents
    ni = sampled_currents(ind).node_indices;
    is = ni.is; js = ni.js; ks = ni.ks; 
    ie = ni.ie; je = ni.je; ke = ni.ke; 

    switch (sampled_currents(ind).direction(1))
    case 'x'
        sampled_value = ...
        + dy * sum(sum(sum(Hy(is:ie-1,js:je,ks-1)))) ...
        + dz * sum(sum(sum(Hz(is:ie-1,je,ks:ke))))...
        - dy * sum(sum(sum(Hy(is:ie-1,js:je,ke))))...
        - dz * sum(sum(sum(Hz(is:ie-1,js-1,ks:ke)))); 
    case 'y'
        sampled_value = ...
        + dz * sum(sum(sum(Hz(is-1,js:je-1,ks:ke)))) ...
        + dx * sum(sum(sum(Hx(is:ie,js:je-1,ke))))...
        - dz * sum(sum(sum(Hz(ie,js:je-1,ks:ke))))...
        - dx * sum(sum(sum(Hx(is:ie,js:je-1,ks-1)))); 
    case 'z'
        sampled_value = ...
        + dx * sum(sum(sum(Hx(is:ie,js-1,ks:ke-1)))) ...
        + dy * sum(sum(sum(Hy(ie,js:je,ks:ke-1))))...
        - dx * sum(sum(sum(Hx(is:ie,je,ks:ke-1))))...
        - dy * sum(sum(sum(Hy(is-1,js:je,ks:ke-1)))); 
    end
    sampled_currents(ind).sampled_value(time_step) = sampled_value * sampled_currents(ind).Cscf;
end

