%% calculate RCS PEC sphere 
% INPUT:
% freq  : frequency in Hz
% a     : radius of the cylinder (m)
% phio  : Phi angle of observation point (radian)
% thetao: Theta angle of observation point (radian)
% r     : Radius of observation point (far-field distance) (m)

% close all;
clear all;
clc; 
freq = 300;
a = 0.5;
thetao = (pi/180)*[0:0.5:180];
phio = 0*(pi/180);
r = 1e3;
Ephi = zeros(length(thetao),1);
Etheta = zeros(length(thetao),1);
RCS = zeros(length(thetao),1);

for i = 1:length(thetao)
    theta = thetao(i);
    [Ep, Et] = mie_sphere_pec(freq, a, phio, theta,  r);
    Ephi(i) = Ep;
    Etheta(i) = Et;
%     RCS(i) = abs(Ephi(i)^2 + Etheta(i)^2)*a*a;
    RCS(i) = abs(Ephi(i)^2 + Etheta(i)^2);
end

RCS = 4*pi*r^2*RCS;
RCS = RCS/max(RCS);
figure()
plot(thetao*(180/pi),10*log10(RCS),'--r')
title('RCS - \phi = 0')

phio = 90*(pi/180);
r = 1e3;
Ephi = zeros(length(thetao),1);
Etheta = zeros(length(thetao),1);
RCS = zeros(length(thetao),1);

for i = 1:length(thetao)
    theta = thetao(i);
    [Ep, Et] = mie_sphere_pec(freq, a, phio, theta,  r);
    Ephi(i) = Ep;
    Etheta(i) = Et;
%     RCS(i) = abs(Ephi(i)^2 + Etheta(i)^2)*a*a;
    RCS(i) = abs(Ephi(i)^2 + Etheta(i)^2);
end
RCS = 4*pi*r^2*RCS;
RCS = RCS/max(RCS);
figure()
plot(thetao*(180/pi),10*log10(RCS),'--r')
% plot(thetao,10*log10(RCS),'--r')

title('RCS - \phi = 90')

