%% calculate RCS multilayer PEC coated sphere 
% INPUT:
% freq  : frequency in Hz
% a     : radius of the cylinder (m)
% phio  : Phi angle of observation point (radian)
% thetao: Theta angle of observation point (radian)
% r     : Radius of observation point (far-field distance) (m)

% close all;
% clear all;
% clc; 
freq = 300;

%% Now the radious (a) and eps are vectors with information in each medium

a0 = 0.3;
a = [0.4 0.5 0.6];
eps = [4 3 2];

% a0 = 0.3;
% a = [0.4 0.5 0.6 0.7 0.8];
% eps = [6 5 4 3 2];

thetao = (pi/180)*[0:0.5:180];
phio = 0*(pi/180);
r = 1e5;
Ephi = zeros(length(thetao),1);
Etheta = zeros(length(thetao),1);
RCS = zeros(length(thetao),1);

for i = 1:length(thetao)
    theta = thetao(i);
    [Ep, Et] = mie_sphere_multi_diel_marlon_teste(freq, a0, a, eps, phio, theta,  r);
    Ephi(i) = Ep;
    Etheta(i) = Et;
    RCS(i) = abs(Ephi(i)^2 + Etheta(i)^2);
end
RCS = 4*pi*r^2*RCS;
RCS = RCS/max(RCS);
RCS_phi1 = 10*log10(RCS);
figure()
plot(thetao*(180/pi),10*log10(RCS),'-r')
title('RCS - \phi = 0')


phio = 90*(pi/180);
Ephi = zeros(length(thetao),1);
Etheta = zeros(length(thetao),1);
RCS = zeros(length(thetao),1);
for i = 1:length(thetao)
    theta = thetao(i);
    [Ep, Et] = mie_sphere_multi_diel_marlon_teste(freq, a0, a, eps, phio, theta,  r);
    Ephi(i) = Ep;
    Etheta(i) = Et;
    RCS(i) = abs(Ephi(i)^2 + Etheta(i)^2);
end

RCS = 4*pi*r^2*RCS;
RCS = RCS/max(RCS);
RCS_phi2 = 10*log10(RCS);
figure()
plot(thetao*(180/pi),10*log10(RCS),'-r')
title('RCS - \phi = 90')

% save('Analytical_sol.mat','RCS_phi1','RCS_phi2')