% initialize the matlab workspace
clear all; 
close all;
clc;

tic
% define the problem 
define_problem_space_parameters;
define_geometry;
define_sources_and_lumped_elements;
define_output_parameters;

% initialize the problem space and parameters 
initialize_fdtd_material_grid;
display_problem_space;
% display_material_mesh;
if run_simulation
    initialize_fdtd_parameters_and_arrays;
    initialize_sources_and_lumped_elements;
    initialize_updating_coefficients;
    initialize_boundary_conditions;
    initialize_output_parameters;
    initialize_farfield_arrays;
    initialize_display_parameters;

    % FDTD time marching loop
    run_fdtd_time_marching_loop;

    % display simulation results
    post_process_and_display_results;
end
toc
figure 
R=real(sampled_voltages.frequency_domain_value./sampled_currents.frequency_domain_value);
X=imag(sampled_voltages.frequency_domain_value./sampled_currents.frequency_domain_value);
plot(frequency_domain.frequencies./1e9,R,frequency_domain.frequencies./1e9,X,'-r','LineWidth',3)
title('IMPEDNCIA DO DIPOLO 1.5 \lambda')
ylabel('IMPEDNCIA (Ohms)');
xlabel('FREQUNCIA (GHz)');
legend('Parte Real','Parte Imaginaria');
ylim([-1000 1000])
grid on;