disp('defining output parameters');

sampled_electric_fields = [];
sampled_magnetic_fields = [];
sampled_voltages = [];
sampled_currents = [];
ports = [];
farfield.frequencies = [];

% figure refresh rate
plotting_step = 10;

% mode of operation
run_simulation = true;
show_material_mesh = true;
show_problem_space = true;

% far field calculation parameters
farfield.frequencies(1) = 0.3e9;
farfield.frequencies(2) = 0.4e9;
farfield.frequencies(3) = 1e9;
farfield.number_of_cells_from_outer_boundary = 13;

% frequency domain parameters
frequency_domain.start = 0.1e9;
frequency_domain.end   = 0.8e9;
frequency_domain.step  = 1e6;

% define sampled voltages
sampled_voltages(1).min_x = 0;
sampled_voltages(1).min_y = 0;
sampled_voltages(1).min_z = -20e-3;
sampled_voltages(1).max_x = 0;
sampled_voltages(1).max_y = 0;
sampled_voltages(1).max_z = 20e-3;
sampled_voltages(1).direction = 'zp';
sampled_voltages(1).display_plot = false;

% define sampled currents
sampled_currents(1).min_x = 0;
sampled_currents(1).min_y = 0;
sampled_currents(1).min_z = 0;
sampled_currents(1).max_x = 0;
sampled_currents(1).max_y = 0;
sampled_currents(1).max_z = 0;
sampled_currents(1).direction = 'zp';
sampled_currents(1).display_plot = false;

% define ports
ports(1).sampled_voltage_index = 1;
ports(1).sampled_current_index = 1;
ports(1).impedance = 50;
ports(1).is_source_port = true;

% define animation
% field_type shall be 'e' or 'h'
% plane cut shall be 'xy', yz, or zx
% component shall be 'x', 'y', 'z', or 'm;
animation(1).field_type = 'h';
animation(1).component = 'm';
animation(1).plane_cut(1).type = 'zx';
animation(1).plane_cut(1).position  = 0;
animation(1).display_grid = false;
animation(1).display_objects = true;
animation(1).save_movie = false;
animation(1).view_angles = [15 15];
animation(1).zoom = 0.8;
animation(1).enable = false;
% animation(1).enable = true;

animation(2).field_type = 'e';
animation(2).component = 'm';
animation(2).plane_cut(1).type = 'zx';
animation(2).plane_cut(1).position  = 0;
animation(2).display_grid = false;
animation(2).display_objects = true;
animation(2).save_movie = false;
animation(2).view_angles = [15 15];
animation(2).zoom = 0.8;
% animation(2).enable = false;
animation(2).enable = true;

