% Capturing sampled currents

for ind=1:number_of_sampled_currents
        is = sampled_currents(ind).is;
        js = sampled_currents(ind).js;
        ks = sampled_currents(ind).ks;
        ie = sampled_currents(ind).ie;
        je = sampled_currents(ind).je;
        ke = sampled_currents(ind).ke;

    switch (sampled_currents(ind).direction(1))
    case 'x'
        sampled_value = ...
        + dy * sum(sum(sum(Hy(ie-1,js:je,ks-1)))) ...
        + dz * sum(sum(sum(Hz(ie-1,je,ks:ke))))...
        - dy * sum(sum(sum(Hy(ie-1,js:je,ke))))...
        - dz * sum(sum(sum(Hz(ie-1,js-1,ks:ke)))); 
    case 'y'
        sampled_value = ...
        + dz * sum(sum(sum(Hz(is-1,je-1,ks:ke)))) ...
        + dx * sum(sum(sum(Hx(is:ie,je-1,ke))))...
        - dz * sum(sum(sum(Hz(ie,je-1,ks:ke))))...
        - dx * sum(sum(sum(Hx(is:ie,je-1,ks-1)))); 
    case 'z'
        sampled_value = ...
        + dx * sum(sum(sum(Hx(is:ie,js-1,ke-1)))) ...
        + dy * sum(sum(sum(Hy(ie,js:je,ke-1))))...
        - dx * sum(sum(sum(Hx(is:ie,je,ke-1))))...
        - dy * sum(sum(sum(Hy(is-1,js:je,ke-1)))); 
    end
    if strcmp(sampled_currents(ind).direction(2),'n')
        sampled_value = -1 * sampled_value;
    end
    sampled_currents(ind).sampled_value(time_step) = sampled_value;
end

