
clear,clc
c=3e8; f=5.4e9; lam=c/f; k0=2*pi/lam; 
Txh=30; d0=50; dx=10; 

alfmd=8; alfamax=alfmd ;
pmax=k0*sind(alfamax);
dz = pi/pmax;

zmax=200;  xmax=20000;
za=0.5*zmax;
Nx=(xmax-d0)/dx 
Nz=round(zmax/dz);

antenna_initial_field;
attenuation_layer;

%Duct ;
%n=1*ones(Nz,1);
NN = 304 - 100.*(z./1000) ;
MM = NN + 157.*(z./1000) ;
m1 = MM.*10^(-6) + 1 ; 
n = m1' ;

a=4*1j*k0*dz^2/dx ; b=k0^2*(n.^2-1)*dz^2;

u=zeros(Nz,Nx) ; u(:,1)=ui;
alfm=-2-a+b; betam= 2-a-b; 

A = diag(alfm) + diag(ones(Nz-1,1),1) + diag(ones(Nz-1,1),-1);
B = diag(betam) + diag(-1*ones(Nz-1,1),1) + diag(-1*ones(Nz-1,1),-1) ;

%%% Finitely conducting boundary %%%
er=15; sigma=0.012; e0=8.85e-12; 
ec=er+1j*sigma/(2*pi*f*e0); dver=sqrt(ec-1)/ec; dhor=sqrt(ec-1);

gam = -1j*k0*dver; 
%gam=-1j*k0*dhor; 
A(1,1)=gam*dz-1-a/2+b(1)/2; B(1,1)=-gam*dz+1-a/2-b(1)/2;

tic
%%%%%%%
for w=1:Nx
    u(:,w+1) = A\B*u(:,w).*af;
end

toc

[X,Y] = meshgrid(d0:dx:xmax,dz:dz:Nz*dz);
Pr=20*log10(abs((lam/(4*pi))*(ones(Nz,1)*(1./sqrt(dx*([1 1:Nx])))).*u));
%Pr= -20.*log10( abs( (lam/(4*pi))*(1./sqrt(X)).*u));
%Pr= -20.*log10( abs( (lam/(4*pi))*(1./sqrt(X)).*u));


%figure(); mesh(X,Y,abs(u)) ; view(2) ;xlabel('Distance(m)');
%figure(); mesh(X,Y,20*log10(abs(u))) ; xlabel('Distance(m)');
%ylabel('Height(m)'); %caxis([-60 -20]); 
%colorbar; view([0 0 1])

%figure(); mesh(X,Y,(abs(u))) ; view(2); xlabel('Distance(m)');
%ylabel('Height(m)');  %view([0 0 1]); %caxis([-60 -20]); colorbar;

figure(); mesh(X,Y,Pr) ; xlabel('Distance(m)'); ylabel('Height(m)'); 
title('Path loss(-dB)'); caxis([-160 -100]); colorbar; view([0 0 1])


%%%%%%%%%%%%%%% PL Profiles %%%%%%%%%
% 
HR = Txh ; 
H_cells = round(HR/dz) ; PL_H = Pr(H_cells, :);
Range = d0:dx:xmax ; 
figure; plot(Range,PL_H) ; xlim([d0 xmax]) ; 
% 
XR = 20000 ; 
X_cells = round(XR/dx) ; PL_V = Pr(:,end) ;
zz = dz:dz:zmax ;
figure; plot(PL_V,zz) ;  ylim([dz za]) ;









