
clear,clc
c=3e8; f=2e9; lam=c/f; k0=2*pi/lam; 
Txh=30; d0=50; dx=10; %dz=0.431118; 

alfmd=8; alfamax=alfmd ;
pmax=k0*sind(alfamax);
dz= pi/pmax;

zmax=200;  xmax=20000;
za=0.5*zmax;
Nx=(xmax-d0)/dx;
Nz=round(zmax/dz)+1;

antenna_initial_field;
attenuation_layer;

%Duct; 
%n=1*ones(Nz,1);
NN = 304 - 100.*(z./1000) ;
MM = NN + 157.*(z./1000) ;
m1 = MM.*10^(-6) + 1 ; 
n = m1;

a=4*1j*k0*dz^2/dx ; b=k0^2*(n.^2-1)*dz^2;

u=zeros(Nz,Nx) ; u(:,1)=ui;
alfm=-2-a+b; betam= 2-a-b; 

A = diag(alfm) + diag(ones(Nz-1,1),1) + diag(ones(Nz-1,1),-1);
B = diag(betam) + diag(-1*ones(Nz-1,1),1) + diag(-1*ones(Nz-1,1),-1) ;

tic
for w=1:Nx
    u(:,w+1) = A\B*u(:,w).*af;
end
toc

%[X,Y] = meshgrid(d0:dx:Nx*dx,dz:dz:Nz*dz);
[X,Y] = meshgrid(d0:dx:xmax,0:dz:(Nz-1)*dz);
Pr= - 20*log10(abs((lam/(4*pi))*(ones(Nz,1)*(1./sqrt(dx*([1 1:Nx])))).*u));
%Pr= -20.*log10( abs( (lam/(4*pi))*(1./sqrt(X)).*u))+2;
%Pr_norm = Pr/(max(Pr)) ;

%figure(); mesh(X,Y,abs(u)) ; view(2) ;xlabel('Distance(m)');
%ylabel('Height(m)'); ylim([0 za]); caxis([0 0.1]); %colorbar; view([0 0 1])

%figure(); mesh(X,Y,(abs(u))) ; xlabel('Distance(m)');
%ylabel('Height(m)');  view([0 0 1]) ; %caxis([-60 -20]); colorbar;

figure(); mesh(X,Y,Pr) ; xlabel('Distance(m)'); ylabel('Height(m)'); 
title('Path loss(-dB)'); caxis([70 150]); colorbar; view([0 0 1]); ylim([0 za]);

%%%%%%%%%%%%%%% PL Profiles %%%%%%%%%

% Horizontal PL Profile
HR = 10 ; %%% Receiver 
H_cells = round(HR/dz) ; PL_H = Pr(H_cells, :);
Range = d0:dx:xmax ; %PL_H_norm = PL_H./max(PL_H) ;
figure; plot(Range,PL_H) ; xlim([500 xmax]) ; ylim([0 200])

% Vertical PL Profile
XR = 20000 ; %%%%%%%%%%
X_cells = round(XR/dx) ; PL_V = Pr(:,end) ;
zz = dz:dz:zmax ;
figure; plot(PL_V,z) ;  ylim([dz za]) ;



